clc
clear all
close all
set(0,'defaultTextInterpreter','latex');          % serve a settare i grafici nei plot
set(0,'defaultAxesFontSize',20);
set(0,'defaultAxesFontName','TimesNewRoman');

%% Costanti fisiche
T=293;          % Temperatura assoluta [K]
T0=273;         % Temperatura assoluta rif. [K]
mu=1.81e-5;     % viscosit` dinamica dell'aria a 0 C [Pas]
R=287.053;      % Costante dell'aria [J/Kg/K]
Pa=1e5;         % Pressione ambiente a 273 K [Pa]
Ps=5e5;         % Pressione alimentazione assoluta a 273 K [Pa]
b_c=0.5283;

Kt=sqrt(T/T0);
rho=Pa/(R*T);   % Densità dell'aria in condizioni normali [kg/m^3]
psi=0.6855/sqrt(R*T);
cost=1/(24*mu*R*T);
dt=1e-7;        % parametro per risolvere con Eulero esplicito
ck=60000/rho;   % per passare da kg/s a l/min

%% Geometria pattino
n_fori=4;       % numero di fori del pattino
dp=1.05e-3;        % diametro del foro di ingresso del pattino 
hg=54e-6;       % profondità media ragnatura
wg=0.16e-3;      % larghezza ragnatura
L=60e-3;
B=30e-3;
l=45e-3;
b=20e-3;
lx=(L-l)/2;
ly=(B-b)/2;
coeff=1;
A=L*B*coeff;            % Aumentando coeff gira più veloce (equivale ad aumentare il passo di tempo)
Vg=1/2*wg*hg*2*(l+b);     % volume ragnatura

%% parametri della valvola
dm=6e-3;                            % diametro membrana metallica m

% mettere i valori ottenuti dal Modello "0" di progetto
xn=     -8e-06;
km=    1.50e+05;      %area/pendenza

dn=0.75e-3;                      % diametro dell'ugello

d_con=5e-3;                         % diametro dei condotti interni al pattino
V_valvola=(6e-3-3.75e-3)^2*pi/4*3.9e-3+(1.875e-3)^2*pi/4*(9)*1e-3;         % Volume della valvola
V_cond=pi*d_con^2/4*(60+30)*1e-3;   % volume dei condotti interni al pattino
V_cavo=pi*(4e-3)^2/4*20e-3;         % volume del tubo tra valvola e pattino
V1=V_valvola+V_cond+V_cavo;         % volume a monte del pattino
S_eqv=(l*b+L*B+0.5*(L*b+B*l))/3;        % superficie equivalente su cui insiste la Fp considerando una distribuz. di pressione a tronco di piramide

c_num=5e4;
%% Vettore delle Variabili Temporali
%Reynolds Conduttanze 
   RRe1t=[];
   RRe2t=[];
   Cda1t=[];
   Cda2t=[];
   Cs1t=[];
   Cs2t=[];
   %Pressioni
   P1t=[];
   P2t=[];
   P0t=[];
% Caratteristiche pattino + valvola 
   H0t=[];
   H_dott=[];
   Xvt=[];
   G1t=[];
   G2t=[];
   G3t=[];
   Fmt=[];
   time=[];
   FFextt=[];

%% Inizializzazione pressioni, Reynolds
p1=Ps; % [Pa]
p2=Ps;
p0=Ps;
Re1=0;
Re2=0;

%% Punto iniziale per trovare le CONDIZIONI INIZIALI

h0=4*1e-6;
V0=h0*l*b;      % volume del meato
V2=V0+Vg;       % volume tot. = volume meato + volume ragnatura

Fp0=0;
g30=0;
err_Fp=10;
err_G=10;
x_bypass=12;   %    [um]
tic
j=0;
toll=1e-9;
while (abs(err_Fp)>toll || abs(err_G)>toll)
j=j+1;

% Calcolo la distanza ugello-membrana
x=xn+(p1-Pa)*(pi*dm^2/4)/km;
% Verifico se sono in condizioni di x_bypass o meno
if x<x_bypass*1e-6
   x=x_bypass*1e-6;
end

% Calcolo la conduttanza dell'ugello della valvola (considero la sezione ANULARE)
cda1=1.05*(1-0.3*exp(-0.005*Re1));
C1=cda1*(pi*x*dn)*Kt*psi;      % conduttanza dell'ugello della valvola con sezione ANULARE

% Calcolo la portata dell'ugello della valvola g1
[g1]=FORO(C1,Ps,p1);        % portata attraverso l'ugello della valvola calcolata con la function FORO 
g1=g1*Kt;
Re1=abs(g1)/(pi*mu*dn);

% Calcolo la conduttanza del foro del pattino (considero la sezione ANULARE)
cda2=1.05*(1-0.3*exp(-0.005*Re2));
C2=cda2*(pi*h0*dp+wg*hg)*Kt*psi;   % conduttanza di un foro del pattino
[g2]=FORO(C2,p1,p2);             % portata attraverso un foro del pattino
g2=g2*Kt;
heq=(pi*h0*dp+hg*wg)/(pi*dp);
Re2=abs(g2)*h0/(pi*dp*mu*heq);

% Portate in uscita dal pattino
gx=cost*(h0)^3*((p0^2-Pa^2)/lx)*b;
gy=cost*(h0)^3*((p0^2-Pa^2)/ly)*l;
g3=2*(gx+gy);  

% Calcolo le pressioni p1, p0 e p2
p1=p1+(g1-g2*n_fori)*dt*R*T/V1;       % applico Eulero esplicito in avanti
p0=p0+(g2*n_fori-g3)*dt*R*T/V2;       % applico Eulero esplicito in avanti

af=0.14;
bf=5e-6;
f=1-af^(bf/h0);        % f=p0/p2;
p2=(1/f)*(p0-Pa)+Pa;   % formula inversa per trovare p2

% Calcolo la forza di pressione Fp dovuta al meato
Fp=S_eqv*(p0-Pa);

% calcolo gli errori per uscire dal while
err_Fp=(Fp-Fp0)/Fp;
err_G=(g3-g30)/g3;
            
Fp0=Fp;
g30=g3;
end
    toc
%% Modello con forza in ingresso a gradino
i=0;
contatore=0;
F_EXT=[Fp:-10:5];

for i=1:length(F_EXT)

    g=9.806;
    h0_dot=0;   % condizione iniziale di velocità --> mi serve per Eulero esplicito in avanti
    err_Fp=10;
    err_G=10;
    err_h=10;
    F_ext=F_EXT(i);
    M(i)=F_ext/g;          % massa supportata dal pattino
    
    tic
while (abs(err_Fp)>toll || abs(err_h)>toll)
j=j+1;
contatore=contatore+1;

% Calcolo distanza ugello-membrana
x=xn+(p1-Pa)*(pi*dm^2/4)/km;
%Caso bypass
if x<x_bypass*1e-6
   x=x_bypass*1e-6;
end

% Conduttanza ugello valvola (si una la sezione anulare)
cda1=1.05*(1-0.3*exp(-0.005*Re1));
C1=cda1*(pi*x*dn)*Kt*psi;    %conduttanza foro valvola con area anulare

%Calcolo portata ugello valvola
[g1]=FORO(C1,Ps,p1);      %portata attraverso l'ugello della valvola   (kg/s)
Re1=abs(g1)/(pi*mu*dn);

%Conduttanza foro pattino (si una la sezione anulare)
cda2=1.05*(1-0.3*exp(-0.005*Re2));
C2=cda2*(pi*h0*dp+wg*hg)*Kt*psi;   %conduttanza di un foro del pattino
[g2]=FORO(C2,p1,p2);             %portata attraverso un foro del pattino    (kg/s)
heq=(pi*h0*dp+hg*wg)/(pi*dp);
Re2=abs(g2)*h0/(pi*dp*mu*heq);

%Portate uscita meato
gx=cost*(h0)^3*((p0^2-Pa^2)/lx)*b;
gy=cost*(h0)^3*((p0^2-Pa^2)/ly)*l;
g3=2*(gx+gy);

%Calcolo forza e nuovo meato di equilibrio
Fp=S_eqv*(p0-Pa);
h1_dot=h0_dot+dt/M(i)*(Fp-F_ext-c_num*h0_dot);       % Eulero esplicito in avanti
h1=h0+h0_dot*dt;                     % Eulero esplicito in avanti

%Calcolo Pressioni
V2=h0*l*b+Vg;
p1=p1+(g1-g2*n_fori)*dt*R*T/V1; % pattino attivo
p0=p0+((g2*n_fori-g3)-h0_dot*A*p0/(R*T))*dt*R*T/V2;
af=0.14;
bf=5e-6;
f=1-af^(bf/h0);    %f=p0/p2;
p2=(1/f)*(p0-Pa)+Pa;

% Calcolo gli errori per uscire dal while
err_Fp=(Fp-F_ext)/F_ext;
err_G=(g3-g30)/g3;
err_h=(h1-h0)/h0;

Fp0=Fp; 
g30=g3;
h0=h1;
h0_dot=h1_dot;
%% VARIABILI TEMPORALI (salvate ogni 2000 punti)
punti=2000;
if contatore==punti
% %Reynolds Conduttanze 
%    RRe1t=[RRe1t Re1];
%    RRe2t=[RRe2t Re2];
%    Cda1t=[Cda1t cda1];
%    Cda2t=[Cda2t cda2];
%    Cs1t=[Cs1t C1];
%    Cs2t=[Cs2t C2];
%  %Pressioni
%    P1t=[P1t p1];
%    P2t=[P2t p2];
%    P0t=[P0t p0];
%Caratteristiche pattino + valvola 
   H0t=[H0t h0]; %(m)
   H_dott=[H_dott h0_dot]; %(m/s)
   Xvt=[Xvt x];
   G1t=[G1t g1*ck];
   G2t=[G2t g2*n_fori*ck];
   G3t=[G3t g3*ck];
   Fmt=[Fmt Fp];
   time=[time dt*j];
   FFextt=[FFextt F_ext];
   
   contatore=0;
end


end

toc
%% VARIABILI CORRISPONDENTI AI PUNTI DI EQUILIBRIO
%    %Reynolds Conduttanze 
%    RRe1(i)=Re1;
%    RRe2(i)=Re2;
%    Cda1(i)=cda1;
%    Cda2(i)=cda2;
%    Cs1(i)=C1;
%    Cs2(i)=C2;
% 
   %Pressioni
   P1(i)=p1;
   P2(i)=p2;
   P0(i)=p0;

%Caratteristiche pattino + valvola 
   H0(i)=h0*1e6;
   H_dot(i)=h0_dot;
   Xv(i)=x;
   G1(i)=g1*ck;
   G2(i)=g2*n_fori*ck;
   G3(i)=g3*ck;
   Fm(i)=Fp;


end
%%
figure
plot(time,Fmt,'b','linewidth',2),grid on, hold on,
plot(time,FFextt,'r','linewidth',2),grid on, hold on,
xlabel(' Time  $(s) $'),
ylabel(' Force  $ \quad F$ $(N)$ '),

figure
plot(time,H0t*1e6,'linewidth',2),grid on, hold on,
xlabel(' Time  $(s) $'),
ylabel(' Air Gap  $ \quad h$ $(\mu m)$ '),

figure
plot(time,G3t*ck,'linewidth',2),grid on, hold on,
xlabel(' Time  $(s) $'),
ylabel(' Air Flow  $ \quad h$ $(\mu m)$ '),
%%

h_min=min(H0);
h_max=max(H0);
F_min=min(Fm);
F_max=max(Fm);

%% CARICAMENTO DATI SALVATI
Spessore=50;
ps=4;
x0=60;
test=3;
pa=101325;
D_foro=6;

%Caricamento Dati
Dati=['load VerificaPattinoC_f' num2str(D_foro) '_' num2str(Spessore) 'um_' num2str(ps) 'bar_x' num2str(x0) '_' num2str(test)];
eval(Dati);

Forza=['Fs=F_pattino_f' num2str(D_foro) '_' num2str(Spessore) 'um_' num2str(ps) 'bar_x' num2str(x0) '_' num2str(test) ';'];
Portata=['Gs=G_pattino_f' num2str(D_foro) '_' num2str(Spessore) 'um_' num2str(ps) 'bar_x' num2str(x0) '_' num2str(test) ';'];
Rigidezza=['Ks=Ks_pattino_f' num2str(D_foro) '_' num2str(Spessore) 'um_' num2str(ps) 'bar_x' num2str(x0) '_' num2str(test) ';'];
Pressione=['Pr=Pr_pattino_f' num2str(D_foro) '_' num2str(Spessore) 'um_' num2str(ps) 'bar_x' num2str(x0) '_' num2str(test) ';'];
Spost_pattino=['Xs=xm_pattino_f' num2str(D_foro) '_' num2str(Spessore) 'um_' num2str(ps) 'bar_x' num2str(x0) '_' num2str(test) ';'];
Spost_valvola=['Xval=xv_pattino_f' num2str(D_foro) '_' num2str(Spessore) 'um_' num2str(ps) 'bar_x' num2str(x0) '_' num2str(test) ';'];

eval(Forza)
eval(Portata)
eval(Rigidezza)
eval(Pressione)
eval(Spost_pattino)
eval(Spost_valvola)

%Riordina le x 
xi=Xval(1);
Xval=(xi-Xval)*1e-6;

shift=3;
%% CAPACITA' DI CARICO
figure 
plot(H0,Fm,'b','linewidth',2),grid on, hold on,
% plot(h30+shift,F30,'r.','linewidth',2,'MarkerSize',16),hold on
plot(Xs+shift,Fs,'r','linewidth',2),grid on, hold on,
xlabel(' Air \quad gap $\quad h$ $(\mu m) $'),
ylabel(' Force  $ \quad F$ $(N)$ '),
grid on, zoom on
legend('modello','sperimentale')
% xlim([1 35])

%% CONSUMO D'ARIA
figure 
plot(H0,G1,'b','linewidth',2),grid on, hold on,
% plot(h30+shift,G30,'r.','linewidth',2,'MarkerSize',16),hold on
plot(Xs+shift,Gs,'r','linewidth',2),grid on, hold on,
xlabel(' Air \quad gap $\quad h$ $(\mu m) $'),
ylabel(' Air \quad Mass \quad Flow \quad Rate  \quad $Q$ $(\frac{l}{min} \quad ANR \quad 20^{\circ}$)'),
grid on, zoom on
legend('modello','sperimentale')
% xlim([1 35])

%% PRESSIONE
figure 
plot(P1-Pa,Xv,'b','linewidth',2),grid on, hold on,
% plot(ps_h30*1e5,-x_mem_h30*1e-6,'r.','linewidth',2,'MarkerSize',16),hold on
plot(Pr*1e5,Xval,'r','linewidth',2),grid on, hold on,
xlabel('Pressione'),
ylabel('Spostamento membrana'),
legend('modello','sperimentale')
grid on, zoom on
% xlim([5 35])

%% SALVATAGGIO PARAMETRIZZATO

% stringa_H0_v=['H0_v'  '_h' num2str(round(abs(h_des))) '=H0;'];
% stringa_Fm_v=['Fm_v'  '_h' num2str(round(abs(h_des))) '=Fm;'];
% stringa_G_v=['G_v'  '_h' num2str(round(abs(h_des))) '=G3;'];
% stringa_Ks_v=['ks_v'  '_h' num2str(round(abs(h_des))) '=k_st;'];
% 
% 
% structure_static=['save Simul3_Stat_Ps' num2str(round(abs(Ps*1e-5))) '_h' num2str(round(abs(h_des))) ' H0_v' '_h' num2str(round(abs(h_des))) ' Fm_v'  '_h' num2str(round(abs(h_des))) ' G_v' '_h' num2str(round(abs(h_des)))  ' ks_v'  '_h' num2str(round(abs(h_des)))];
% 
% eval(stringa_H0_v)
% eval(stringa_Fm_v)
% eval(stringa_G_v)
% eval(stringa_Ks_v)
% 
% 
% eval(structure_static) 
 